
<?php $__env->startSection('panel'); ?>
    <div class="row mb-none-30">
        <div class="col-lg-12 col-md-12 mb-30">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('staff.courier.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="card border--primary mt-3">
                                    <h5 class="card-header bg--primary  text-white"><?php echo app('translator')->get('Sender Information'); ?></h5>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <label for="sender_name" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Name'); ?></label>
                                                <input type="text" class="form-control form-control-lg" id="sender_name" name="sender_name" value="<?php echo e(old('sender_name')); ?>" placeholder="<?php echo app('translator')->get("Enter Sender Name"); ?>"  maxlength="40" required="">
                                            </div>

                                             <div class="form-group col-lg-6">
                                                <label for="sender_phone" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Phone'); ?></label>
                                                <input type="text" class="form-control form-control-lg" id="phone" value="<?php echo e(old('sender_phone')); ?>" name="sender_phone" placeholder="<?php echo app('translator')->get("Enter Sender Phone"); ?>"  maxlength="40" required="">
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="form-group col-lg-12">
                                                <label for="sender_email" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Email'); ?></label>
                                                <input type="email" class="form-control form-control-lg" id="sender_email" name="sender_email" value="<?php echo e(old('sender_email')); ?>" placeholder="<?php echo app('translator')->get("Enter Sender Email"); ?>"  maxlength="40" required="">
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="form-group col-lg-12">
                                                <label for="sender_address" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Address'); ?></label>
                                                <input type="text" class="form-control form-control-lg" id="sender_address" name="sender_address" value="<?php echo e(old('sender_address')); ?>" placeholder="<?php echo app('translator')->get("Enter Sender Address"); ?>"  maxlength="255" required="">
                                            </div>
                                        </div>  
                                    </div> 
                                </div>
                            </div>


                             <div class="col-lg-6">
                                <div class="card border--primary mt-3">
                                    <h5 class="card-header bg--primary  text-white"><?php echo app('translator')->get('Receiver Information'); ?></h5>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <label for="=branch" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Select Branch'); ?></label>
                                                <select class="form-control form-control-lg" name="branch" id="branch" required="">
                                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                                    <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($branch->id); ?>"><?php echo e(__($branch->name)); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-lg-6">
                                                <label for="receiver_name" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Name'); ?></label>
                                                <input type="text" class="form-control form-control-lg" id="receiver_name" name="receiver_name" value="<?php echo e(old('receiver_name')); ?>" placeholder="<?php echo app('translator')->get("Enter Receiver Name"); ?>"  maxlength="40" required="">
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="form-group col-lg-6">
                                                <label for="receiver_phone" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Phone'); ?></label>
                                                <input type="text" class="form-control form-control-lg" id="receiver_phone" name="receiver_phone" placeholder="<?php echo app('translator')->get("Enter Receiver Phone"); ?>" value="<?php echo e(old('receiver_phone')); ?>" required="">
                                            </div>


                                            <div class="form-group col-lg-6">
                                                <label for="receiver_email" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Email'); ?></label>
                                                <input type="email" class="form-control form-control-lg" id="receiver_email" name="receiver_email" value="<?php echo e(old('receiver_email')); ?>" placeholder="<?php echo app('translator')->get("Enter Receiver Email"); ?>"  required="">
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="form-group col-lg-12">
                                                <label for="receiver_address" class="form-control-label font-weight-bold"><?php echo app('translator')->get('Address'); ?></label>
                                                <input type="text" class="form-control form-control-lg" id="receiver_address" name="receiver_address" placeholder="<?php echo app('translator')->get("Enter Receiver Address"); ?>" value="<?php echo e(old('receiver_address')); ?>"  required="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                        <div class="row mb-30">
                            <div class="col-lg-12">
                                <div class="card border--primary mt-3">
                                    <h5 class="card-header bg--primary  text-white"><?php echo app('translator')->get('Courier Information'); ?>
                                        <button type="button" class="btn btn-sm btn-outline-light float-right addUserData"><i class="la la-fw la-plus"></i><?php echo app('translator')->get('Add New One'); ?>
                                        </button>
                                    </h5>

                                    <div class="card-body">
                                        <div class="row addedField">
                                            <div class="col-md-12 user-data">
                                                <div class="form-group">
                                                    <div class="input-group mb-md-0 mb-4">
                                                        <div class="col-md-4">
                                                            <select class="form-control form-control-lg" id="courier_type_0" onchange="currierType(0)" name="courierName[]">
                                                                <option><?php echo app('translator')->get('Select One'); ?></option>
                                                                <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($type->id); ?>" data-unit="<?php echo e($type->unit->name); ?>" data-price=<?php echo e(getAmount($type->price)); ?>><?php echo e(__($type->name)); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                        <div class="col-md-3 mt-md-0 mt-2">
                                                            <div class="input-group mb-3">
                                                                <input type="text" class="form-control form-control-lg currier_quantity_0" placeholder="<?php echo app('translator')->get('Quantity'); ?>" disabled="" name="quantity[]" onkeyup="courierQuantity(0)" aria-label="Recipient's username" aria-describedby="basic-addon2" required="">
                                                                <div class="input-group-append">
                                                                    <span class="input-group-text" id="unit_0"><i class="las la-balance-scale"></i></span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-3 mt-md-0 mt-2">
                                                           <div class="input-group mb-3">
                                                                <input type="text" id="amount" class="form-control form-control-lg currier_fee_0" placeholder="<?php echo app('translator')->get('Enter Price'); ?>" name="amount[]" aria-label="Recipient's username" aria-describedby="basic-addon2" required="" readonly="">
                                                                <div class="input-group-append">
                                                                    <span class="input-group-text" id="basic-addon2"><?php echo e($general->cur_text); ?></span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div> 
                                    </div> 
                                </div>
                            </div>
                        </div> 
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn--primary btn-block"><i class="fa fa-fw fa-paper-plane"></i> <?php echo app('translator')->get('Send Courier'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(route('staff.dashboard')); ?>" class="btn btn-sm btn--primary box--shadow1 text--small"><i class="las la-angle-double-left"></i> <?php echo app('translator')->get('Go Back'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    "use strict";
    function currierType(id) {
        let unit = $("#courier_type_" + id).find(':selected').data('unit');
        let price = $("#courier_type_" + id).find(':selected').data('price');
        $("#unit_" + id).html(unit);

        if ($('#courier_type_' + id).val()) {
            $(".currier_quantity_" + id).removeAttr("disabled");
        }
    }

    function courierQuantity(id)
    {
        let quantity = $(".currier_quantity_" + id).val();
        let price = $("#courier_type_" + id).find(':selected').data('price');
        $(".currier_fee_" + id).val(quantity * price);
    }

    $(document).ready(function () {
        let id = 0;
        $('.addUserData').on('click', function () {
            id++;
            let html = `<div class="col-md-12 user-data">
                            <div class="form-group">
                                <div class="input-group mb-md-0 mb-4">
                                    <div class="col-md-4">
                                        <select class="form-control form-control-lg" id="courier_type_${id}" onchange="currierType(${id})" name="courierName[]" required="">
                                            <option><?php echo app('translator')->get('Select One'); ?></option>
                                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($type->id); ?>" data-unit="<?php echo e($type->unit->name); ?>" data-price=<?php echo e(getAmount($type->price)); ?>><?php echo e(__($type->name)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mt-md-0 mt-2">
                                        <div class="input-group mb-3">
                                            <input type="text" class="form-control form-control-lg currier_quantity_${id}" placeholder="<?php echo app('translator')->get('Quantity'); ?>" disabled="" onkeyup="courierQuantity(${id})" name="quantity[]" aria-label="Recipient's username" aria-describedby="basic-addon2" required="">
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="unit_${id}"><i class="las la-balance-scale"></i></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3 mt-md-0 mt-2">
                                       <div class="input-group mb-3">
                                            <input type="text" id="amount" class="form-control form-control-lg currier_fee_${id}" placeholder="<?php echo app('translator')->get('Enter Price'); ?>" name="amount[]" aria-label="Recipient's username" aria-describedby="basic-addon2" required="" readonly="">
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="basic-addon2"><?php echo e($general->cur_text); ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-2 mt-md-0 mt-2 text-right">
                                        <span class="input-group-btn">
                                            <button class="btn btn--danger btn-lg removeBtn w-100" type="button">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </span>
                                    </div>

                                </div>
                            </div>
                        </div>`;
            $('.addedField').append(html)
        });

        $(document).on('click', '.removeBtn', function () {
            $(this).closest('.user-data').remove();
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('staff.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highogyr/public_html/core/resources/views/staff/courier.blade.php ENDPATH**/ ?>